/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.util;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class FtbUtil {
    public static FTBTeamsAPI.API getAPI() {
        return FTBTeamsAPI.api();
    }

    @Nullable
    public static TeamManager getTeamManager() {
        if (!FtbUtil.getAPI().isManagerLoaded()) {
            return null;
        }
        return FtbUtil.getAPI().getManager();
    }

    @Nullable
    public static ClientTeamManager getClientTeamManager() {
        if (!FtbUtil.getAPI().isClientManagerLoaded()) {
            return null;
        }
        return FtbUtil.getAPI().getClientManager();
    }

    @Nullable
    public static Team getTeam(UUID id, boolean isPlayerId) {
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return null;
        }
        if (!isPlayerId) {
            Optional optionalTeam = manager.getTeamByID(id);
            return optionalTeam.orElse(null);
        }
        Collection teams = manager.getTeams();
        for (Team team : teams) {
            if (!team.isPartyTeam() || !team.getMembers().contains(id)) continue;
            return team;
        }
        return FtbUtil.getPlayerTeam(id);
    }

    @Nullable
    public static Team getClientTeam(UUID id, boolean isPlayerId) {
        ClientTeamManager manager = FtbUtil.getClientTeamManager();
        if (manager == null) {
            return null;
        }
        if (!isPlayerId) {
            Optional optionalTeam = manager.getTeamByID(id);
            return optionalTeam.orElse(null);
        }
        Collection teams = manager.getTeams();
        for (Team team : teams) {
            if (!team.isPartyTeam() || !team.getMembers().contains(id)) continue;
            return team;
        }
        return FtbUtil.getPlayerTeam(id);
    }

    @Nullable
    public static Team getTeam(Player player) {
        if (player instanceof ServerPlayer) {
            return FtbUtil.getTeam(player.m_20148_(), true);
        }
        return EffectiveSide.get().isClient() ? FtbUtil.getClientTeam(player.m_20148_(), true) : null;
    }

    @Nullable
    public static Team getPlayerTeam(UUID playerId) {
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return null;
        }
        Optional optionalTeam = manager.getPlayerTeamForPlayerID(playerId);
        return optionalTeam.orElse(null);
    }

    @Nullable
    public static Team getClientPlayerTeam(UUID playerId) {
        ClientTeamManager manager = FtbUtil.getClientTeamManager();
        if (manager == null) {
            return null;
        }
        Optional optionalTeam = manager.getTeamByID(playerId);
        return optionalTeam.orElse(null);
    }

    @Nullable
    public static Team getPlayerTeam(Player player) {
        if (player instanceof ServerPlayer) {
            return FtbUtil.getPlayerTeam(player.m_20148_());
        }
        return EffectiveSide.get().isClient() ? FtbUtil.getClientPlayerTeam(player.m_20148_()) : null;
    }
}

