/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.mixin;

import dev.scsupercraft.teamstages.data.TeamStageHelper;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={GameStageHelper.class})
public class GameStageHelperMixin {
    @Overwrite(remap=false)
    public static int clearStages(ServerPlayer player) {
        IStageData data = GameStageSaveHandler.getClientData();
        if (data != null) {
            int stageCount = data.getStages().size();
            data.clear();
            TeamStageHelper.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Cleared((Player)player, data));
            return stageCount - data.getStages().size();
        }
        return 0;
    }

    @Overwrite(remap=false)
    public static void syncPlayer(ServerPlayer player) {
        TeamStageHelper.syncPlayer(player);
    }
}

