/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.data;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.scsupercraft.teamstages.TeamStages;
import dev.scsupercraft.teamstages.data.GameStageData;
import dev.scsupercraft.teamstages.data.IGameStageData;
import dev.scsupercraft.teamstages.data.TeamStageHelper;
import dev.scsupercraft.teamstages.util.FtbUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public class TeamStageSaveHandler {
    private static boolean loaded = false;
    private static final Map<UUID, IStageData> GLOBAL_STAGE_DATA = new HashMap<UUID, IStageData>();
    private static Map<UUID, IStageData> GLOBAL_PLAYER_STAGE_DATA = Collections.emptyMap();

    @ApiStatus.Internal
    public static void setGlobalPlayerStageData(Map<UUID, IStageData> stageData) {
        if (GLOBAL_PLAYER_STAGE_DATA != Collections.EMPTY_MAP) {
            throw new IllegalStateException("Attempted to set global player stage data, but it was already set");
        }
        GLOBAL_PLAYER_STAGE_DATA = stageData;
    }

    @ApiStatus.Internal
    public static void init() throws ClassNotFoundException {
        Class.forName("net.darkhax.gamestages.data.GameStageSaveHandler");
        TeamEvent.PLAYER_CHANGED.register(TeamStageSaveHandler::onPlayerChangeParty);
        TeamEvent.CREATED.register(TeamStageSaveHandler::onPartyCreated);
        TeamEvent.DELETED.register(TeamStageSaveHandler::onPartyDeleted);
    }

    private static void onPlayerChangeParty(PlayerChangedTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        GameStageData data = (GameStageData)GLOBAL_PLAYER_STAGE_DATA.get(player.m_20148_());
        if (data != null) {
            data.teamStageData = GLOBAL_STAGE_DATA.get(event.getTeam().getTeamId());
            TeamStageHelper.syncPlayer(player);
        }
    }

    private static void onPartyCreated(TeamCreatedEvent event) {
        Team team = event.getTeam();
        UUID teamId = team.getTeamId();
        Team playerTeam = FtbUtil.getPlayerTeam(event.getCreatorId());
        if (team.isPartyTeam() && playerTeam != null) {
            TeamStageSaveHandler.copyTeamData(playerTeam.getTeamId(), teamId);
        } else {
            TeamStageSaveHandler.createTeamData(teamId);
        }
    }

    private static void onPartyDeleted(TeamEvent event) {
        UUID uuid = event.getTeam().getTeamId();
        GLOBAL_STAGE_DATA.remove(uuid);
        File file = TeamStageSaveHandler.getTeamFile(uuid.toString());
        if (file.exists() && !file.delete()) {
            TeamStages.LOGGER.warn("Failed to delete file: {}", (Object)file);
        }
    }

    @ApiStatus.Internal
    public static void onPlayerLoad(File playerFile, UUID uuid, Component name) {
        GameStageData stageData = new GameStageData();
        if (playerFile.exists()) {
            try {
                IStageData data;
                CompoundTag tag = NbtIo.m_128937_((File)playerFile);
                stageData.readFromNBT(tag);
                Team team = FtbUtil.getTeam(uuid, true);
                IStageData iStageData = data = team != null ? TeamStageSaveHandler.getTeamData(team.getTeamId()) : null;
                if (data != null) {
                    stageData.teamStageData = data;
                } else {
                    TeamStages.LOGGER.warn("Failed to get team data for player '{}'", (Object)name);
                }
                GameStages.LOG.debug("Loaded {} stages for {}.", (Object)stageData.getStages().size(), (Object)name);
            }
            catch (IOException exception) {
                GameStages.LOG.error("Could not read player data for {}.", (Object)name);
                GameStages.LOG.catching((Throwable)exception);
            }
        }
        GLOBAL_PLAYER_STAGE_DATA.put(uuid, stageData);
    }

    @ApiStatus.Internal
    public static void save() {
        TeamStageSaveHandler.createSaveDirectory();
        GLOBAL_STAGE_DATA.forEach(TeamStageSaveHandler::save);
    }

    private static void save(UUID teamID, IStageData data) {
        try {
            CompoundTag tag = data.writeToNBT();
            NbtIo.m_128944_((CompoundTag)tag, (File)TeamStageSaveHandler.getTeamFile(teamID.toString()));
        }
        catch (IOException e) {
            Team team = FtbUtil.getTeam(teamID, false);
            TeamStages.LOGGER.error("Failed to save data for team {}", (Object)(team != null ? team.getShortName() : "unknown"), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void load() {
        if (loaded) {
            return;
        }
        File saveDir = TeamStageSaveHandler.getSaveDirectory().toFile();
        GLOBAL_STAGE_DATA.clear();
        if (!saveDir.exists()) {
            TeamStageSaveHandler.registerAllTeams();
            loaded = true;
            return;
        }
        try {
            File[] files = saveDir.listFiles(File::isFile);
            if (files == null) {
                throw new IOException();
            }
            for (File file : files) {
                try {
                    StageData data = new StageData();
                    String fileName = file.getName();
                    int extensionIndex = fileName.lastIndexOf(46);
                    UUID teamId = UUID.fromString(fileName.substring(0, extensionIndex));
                    CompoundTag tag = NbtIo.m_128937_((File)file);
                    data.readFromNBT(tag);
                    GLOBAL_STAGE_DATA.put(teamId, (IStageData)data);
                    Team team = FtbUtil.getTeam(teamId, false);
                    TeamStages.LOGGER.debug("Loaded {} stages for {}.", (Object)data.getStages().size(), (Object)(team != null ? team.getShortName() : "unknown"));
                }
                catch (IOException e) {
                    TeamStages.LOGGER.error("Could not read team data for file {}.", (Object)file.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            TeamStages.LOGGER.error("An error occurred while trying to load team stages!", (Throwable)e);
        }
        finally {
            TeamStageSaveHandler.registerAllTeams();
            loaded = true;
        }
    }

    @ApiStatus.Internal
    public static void markUnloaded() {
        loaded = false;
    }

    private static void registerAllTeams() {
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return;
        }
        for (Team team2 : manager.getTeams()) {
            UUID teamId = team2.getTeamId();
            if (GLOBAL_STAGE_DATA.containsKey(teamId)) continue;
            TeamStageSaveHandler.createTeamData(teamId);
        }
        manager.getKnownPlayerTeams().forEach((uuid, team) -> {
            if (!GLOBAL_STAGE_DATA.containsKey(uuid)) {
                TeamStageSaveHandler.createTeamData(uuid);
            }
        });
    }

    private static void createTeamData(UUID uuid) {
        GLOBAL_STAGE_DATA.put(uuid, (IStageData)new StageData());
    }

    private static void copyTeamData(UUID srcTeamId, UUID destTeamId) {
        StageData stageData = new StageData();
        IStageData srcData = TeamStageSaveHandler.getTeamData(srcTeamId);
        if (srcData == null) {
            return;
        }
        for (String stage : srcData.getStages()) {
            stageData.addStage(stage);
        }
        GLOBAL_STAGE_DATA.put(destTeamId, (IStageData)stageData);
    }

    @Nullable
    public static IStageData getTeamData(UUID uuid) {
        return GLOBAL_STAGE_DATA.get(uuid);
    }

    @Nullable
    public static IStageData getTeamDataForPlayer(UUID uuid) {
        GameStageData data = (GameStageData)GLOBAL_PLAYER_STAGE_DATA.get(uuid);
        return data != null ? data.teamStageData : null;
    }

    @Nullable
    public static IStageData getPlayerData(UUID uuid) {
        GameStageData data = (GameStageData)GLOBAL_PLAYER_STAGE_DATA.get(uuid);
        return data != null ? data.playerStageData : null;
    }

    public static IGameStageData getGameDataForPlayer(UUID uuid) {
        return (IGameStageData)GLOBAL_PLAYER_STAGE_DATA.get(uuid);
    }

    private static File getTeamFile(String uuid) {
        return new File(TeamStageSaveHandler.createSaveDirectory(), uuid + ".dat");
    }

    private static Path getSaveDirectory() {
        return TeamStages.server.m_129843_(LevelResource.f_78182_).resolve("ftbteams/teamstages");
    }

    private static File createSaveDirectory() {
        File saveDir = TeamStageSaveHandler.getSaveDirectory().toFile();
        if (!saveDir.exists() && !saveDir.mkdirs()) {
            TeamStages.LOGGER.error("Failed to create save directory: {}", (Object)saveDir);
        }
        return saveDir;
    }

    public static void setClientData(Collection<String> player, Collection<String> team) {
        GameStageData stageData = new GameStageData();
        stageData.teamStageData = new StageData();
        for (String stage : player) {
            stageData.playerStageData.addStage(stage);
        }
        for (String stage : team) {
            stageData.teamStageData.addStage(stage);
        }
        GameStageSaveHandler.setClientData((IStageData)stageData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IStageData getClientPlayerData() {
        IStageData iStageData;
        IStageData iStageData2 = GameStageSaveHandler.getClientData();
        if (iStageData2 instanceof GameStageData) {
            GameStageData data = (GameStageData)iStageData2;
            iStageData = data.playerStageData;
        } else {
            iStageData = null;
        }
        return iStageData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IStageData getClientTeamData() {
        IStageData iStageData;
        IStageData iStageData2 = GameStageSaveHandler.getClientData();
        if (iStageData2 instanceof GameStageData) {
            GameStageData data = (GameStageData)iStageData2;
            iStageData = data.teamStageData;
        } else {
            iStageData = null;
        }
        return iStageData;
    }
}

