/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.data;

import dev.ftb.mods.ftbteams.api.Team;
import dev.scsupercraft.teamstages.TeamStages;
import dev.scsupercraft.teamstages.config.CommonConfig;
import dev.scsupercraft.teamstages.data.EmptyStageData;
import dev.scsupercraft.teamstages.data.GameStageData;
import dev.scsupercraft.teamstages.data.TeamStageSaveHandler;
import dev.scsupercraft.teamstages.event.TeamStageEvent;
import dev.scsupercraft.teamstages.packet.MessageTeamStages;
import dev.scsupercraft.teamstages.packet.TeamStagesPacketHandler;
import dev.scsupercraft.teamstages.util.FtbUtil;
import dev.scsupercraft.teamstages.util.GameStageEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.advancement.HasStageTrigger;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class TeamStageHelper {
    private static final PlayerHelper PLAYER = new PlayerHelper();
    private static final TeamHelper TEAM = new TeamHelper();

    public static boolean isValidStageName(String stageName) {
        return GameStageHelper.isValidStageName((String)stageName);
    }

    public static Set<String> getKnownStages() {
        return GameStageSaveHandler.getKnownStages();
    }

    public static boolean isStageKnown(String stage) {
        return GameStageSaveHandler.isStageKnown((String)stage);
    }

    public static PlayerHelper player() {
        return PLAYER;
    }

    public static TeamHelper team() {
        return TEAM;
    }

    private TeamStageHelper() {
    }

    public static void syncTeam(Team team) {
        team.getOnlineMembers().forEach(TeamStageHelper::syncPlayer);
    }

    public static void syncPlayer(ServerPlayer player) {
        ArrayList list;
        GameStageData gameData = (GameStageData)GameStageHelper.getPlayerData((Player)player);
        if (gameData == null) {
            return;
        }
        IStageData playerData = gameData.playerStageData;
        IStageData teamData = gameData.teamStageData;
        TeamStages.LOGGER.debug("Syncing {} player stages and {} team stages for {}.", new Object[]{playerData.getStages().size(), teamData.getStages().size(), player.m_7755_()});
        TeamStagesPacketHandler.sendToClient(player, new MessageTeamStages(playerData.getStages(), teamData.getStages()));
        GameStageEffect effect = CommonConfig.checkEffect;
        ArrayList arrayList = list = effect.isPlayerEffect() ? new ArrayList(playerData.getStages()) : new ArrayList();
        if (effect.isTeamEffect()) {
            list.addAll(teamData.getStages());
        }
        for (String stage : list) {
            HasStageTrigger.INSTANCE.trigger(player, stage);
        }
    }

    public static class PlayerHelper {
        private PlayerHelper() {
        }

        public boolean hasStage(Player player, String stage) {
            return this.hasStage(player, this.getPlayerData(player), stage);
        }

        public boolean hasStage(Player player, @Nullable IStageData data, String stage) {
            if (data != null) {
                GameStageEvent.Check event = new GameStageEvent.Check(player, stage, data.hasStage(stage));
                MinecraftForge.EVENT_BUS.post((Event)event);
                return event.hasStage();
            }
            return false;
        }

        public boolean hasAnyOf(Player player, String ... stages) {
            return this.hasAnyOf(player, this.getPlayerData(player), stages);
        }

        public boolean hasAnyOf(Player player, Collection<String> stages) {
            return this.hasAnyOf(player, this.getPlayerData(player), stages);
        }

        public boolean hasAnyOf(Player player, @Nullable IStageData data, Collection<String> stages) {
            return stages.stream().anyMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public boolean hasAnyOf(Player player, @Nullable IStageData data, String ... stages) {
            return Arrays.stream(stages).anyMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public boolean hasAllOf(Player player, String ... stages) {
            return this.hasAllOf(player, this.getPlayerData(player), stages);
        }

        public boolean hasAllOf(Player player, Collection<String> stages) {
            return this.hasAllOf(player, this.getPlayerData(player), stages);
        }

        public boolean hasAllOf(Player player, @Nullable IStageData data, Collection<String> stages) {
            return stages.stream().allMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public boolean hasAllOf(Player player, @Nullable IStageData data, String ... stages) {
            return Arrays.stream(stages).allMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public void addStage(ServerPlayer player, String ... stages) {
            for (String stage : stages) {
                IStageData data;
                if (MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Add((Player)player, stage)) || (data = this.getPlayerData((Player)player)) == null) continue;
                data.addStage(stage);
                TeamStageHelper.syncPlayer(player);
                MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Added((Player)player, stage));
            }
        }

        public void removeStage(ServerPlayer player, String ... stages) {
            for (String stage : stages) {
                IStageData data;
                if (MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Remove((Player)player, stage)) || (data = this.getPlayerData((Player)player)) == null) continue;
                data.removeStage(stage);
                TeamStageHelper.syncPlayer(player);
                MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Removed((Player)player, stage));
            }
        }

        public int clearStages(ServerPlayer player) {
            IStageData stageInfo = this.getPlayerData((Player)player);
            if (stageInfo != null) {
                int stageCount = stageInfo.getStages().size();
                stageInfo.clear();
                TeamStageHelper.syncPlayer(player);
                MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Cleared((Player)player, stageInfo));
                return stageCount;
            }
            return 0;
        }

        @Nullable
        public IStageData getPlayerData(Player player) {
            if (player != null) {
                if (player instanceof ServerPlayer) {
                    if (player instanceof FakePlayer) {
                        return GameStageSaveHandler.getFakeData((String)player.m_7755_().getString());
                    }
                    return TeamStageSaveHandler.getPlayerData(player.m_20148_());
                }
                if (EffectiveSide.get().isClient()) {
                    return TeamStageSaveHandler.getClientPlayerData();
                }
            }
            return null;
        }
    }

    public static class TeamHelper {
        private TeamHelper() {
        }

        public boolean hasStage(Player player, String stage) {
            return this.hasStage(player, this.getTeamData(player), stage);
        }

        public boolean hasStage(Player player, @Nullable IStageData data, String stage) {
            return this.hasStage(FtbUtil.getTeam(player), data, stage);
        }

        public boolean hasAnyOf(Player player, String ... stages) {
            return this.hasAnyOf(player, this.getTeamData(player), stages);
        }

        public boolean hasAnyOf(Player player, Collection<String> stages) {
            return this.hasAnyOf(player, this.getTeamData(player), stages);
        }

        public boolean hasAnyOf(Player player, @Nullable IStageData data, Collection<String> stages) {
            return stages.stream().anyMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public boolean hasAnyOf(Player player, @Nullable IStageData data, String ... stages) {
            return Arrays.stream(stages).anyMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public boolean hasAllOf(Player player, String ... stages) {
            return this.hasAllOf(player, this.getTeamData(player), stages);
        }

        public boolean hasAllOf(Player player, Collection<String> stages) {
            return this.hasAllOf(player, this.getTeamData(player), stages);
        }

        public boolean hasAllOf(Player player, @Nullable IStageData data, Collection<String> stages) {
            return stages.stream().allMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public boolean hasAllOf(Player player, @Nullable IStageData data, String ... stages) {
            return Arrays.stream(stages).allMatch(stage -> this.hasStage(player, data, (String)stage));
        }

        public void addStage(ServerPlayer player, String ... stages) {
            this.addStage(FtbUtil.getTeam((Player)player), stages);
        }

        public void removeStage(ServerPlayer player, String ... stages) {
            this.removeStage(FtbUtil.getTeam((Player)player), stages);
        }

        public int clearStages(ServerPlayer player) {
            return this.clearStages(FtbUtil.getTeam((Player)player));
        }

        public boolean hasStage(Team team, String stage) {
            return this.hasStage(team, this.getTeamData(team), stage);
        }

        public boolean hasStage(Team team, @Nullable IStageData data, String stage) {
            if (data != null) {
                boolean hasStage = data.hasStage(stage);
                TeamStageEvent.Check event = new TeamStageEvent.Check(team, stage, hasStage);
                MinecraftForge.EVENT_BUS.post((Event)event);
                hasStage = event.hasStage();
                for (ServerPlayer member : team.getOnlineMembers()) {
                    GameStageEvent.Check gameStageEvent = new GameStageEvent.Check((Player)member, stage, hasStage);
                    MinecraftForge.EVENT_BUS.post((Event)gameStageEvent);
                    hasStage = event.hasStage();
                }
                return hasStage;
            }
            return false;
        }

        public boolean hasAnyOf(Team team, String ... stages) {
            return this.hasAnyOf(team, this.getTeamData(team), stages);
        }

        public boolean hasAnyOf(Team team, Collection<String> stages) {
            return this.hasAnyOf(team, this.getTeamData(team), stages);
        }

        public boolean hasAnyOf(Team team, @Nullable IStageData data, Collection<String> stages) {
            return stages.stream().anyMatch(stage -> this.hasStage(team, data, (String)stage));
        }

        public boolean hasAnyOf(Team team, @Nullable IStageData data, String ... stages) {
            return Arrays.stream(stages).anyMatch(stage -> this.hasStage(team, data, (String)stage));
        }

        public boolean hasAllOf(Team team, String ... stages) {
            return this.hasAllOf(team, this.getTeamData(team), stages);
        }

        public boolean hasAllOf(Team team, Collection<String> stages) {
            return this.hasAllOf(team, this.getTeamData(team), stages);
        }

        public boolean hasAllOf(Team team, @Nullable IStageData data, Collection<String> stages) {
            return stages.stream().allMatch(stage -> this.hasStage(team, data, (String)stage));
        }

        public boolean hasAllOf(Team team, @Nullable IStageData data, String ... stages) {
            return Arrays.stream(stages).allMatch(stage -> this.hasStage(team, data, (String)stage));
        }

        public void addStage(Team team, String ... stages) {
            IStageData data = this.getTeamData(team);
            if (data != null) {
                for (String stage : stages) {
                    if (MinecraftForge.EVENT_BUS.post((Event)new TeamStageEvent.Add(team, stage))) continue;
                    boolean cancelled = false;
                    for (ServerPlayer member : team.getOnlineMembers()) {
                        if (!MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Add((Player)member, stage))) continue;
                        cancelled = true;
                        break;
                    }
                    if (cancelled) continue;
                    data.addStage(stage);
                    TeamStageHelper.syncTeam(team);
                    MinecraftForge.EVENT_BUS.post((Event)new TeamStageEvent.Added(team, stage));
                    for (ServerPlayer member : team.getOnlineMembers()) {
                        MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Added((Player)member, stage));
                    }
                }
            }
        }

        public void removeStage(Team team, String ... stages) {
            IStageData data = this.getTeamData(team);
            if (data != null) {
                for (String stage : stages) {
                    if (MinecraftForge.EVENT_BUS.post((Event)new TeamStageEvent.Remove(team, stage))) continue;
                    boolean cancelled = false;
                    for (ServerPlayer member : team.getOnlineMembers()) {
                        if (!MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Remove((Player)member, stage))) continue;
                        cancelled = true;
                        break;
                    }
                    if (cancelled) continue;
                    data.removeStage(stage);
                    TeamStageHelper.syncTeam(team);
                    MinecraftForge.EVENT_BUS.post((Event)new TeamStageEvent.Removed(team, stage));
                    for (ServerPlayer member : team.getOnlineMembers()) {
                        MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Removed((Player)member, stage));
                    }
                }
            }
        }

        public int clearStages(Team team) {
            IStageData stageInfo = this.getTeamData(team);
            if (stageInfo != null) {
                int stageCount = stageInfo.getStages().size();
                stageInfo.clear();
                TeamStageHelper.syncTeam(team);
                MinecraftForge.EVENT_BUS.post((Event)new TeamStageEvent.Cleared(team, stageInfo));
                for (ServerPlayer member : team.getOnlineMembers()) {
                    MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Cleared((Player)member, stageInfo));
                }
                return stageCount;
            }
            return 0;
        }

        @Nullable
        public IStageData getTeamData(Player player) {
            if (player != null) {
                if (player instanceof ServerPlayer) {
                    if (player instanceof FakePlayer) {
                        return new EmptyStageData();
                    }
                    return TeamStageSaveHandler.getTeamDataForPlayer(player.m_20148_());
                }
                if (EffectiveSide.get().isClient()) {
                    return TeamStageSaveHandler.getClientTeamData();
                }
            }
            return null;
        }

        @Nullable
        public IStageData getTeamData(Team team) {
            if (team != null) {
                if (EffectiveSide.get().isClient()) {
                    return TeamStageSaveHandler.getClientTeamData();
                }
                return TeamStageSaveHandler.getTeamData(team.getTeamId());
            }
            return null;
        }
    }
}

