/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.data;

import dev.scsupercraft.teamstages.config.CommonConfig;
import dev.scsupercraft.teamstages.data.EmptyStageData;
import dev.scsupercraft.teamstages.data.IGameStageData;
import dev.scsupercraft.teamstages.util.GameStageEffect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

class GameStageData
implements IGameStageData {
    final IStageData playerStageData = new StageData();
    @NotNull
    IStageData teamStageData = new EmptyStageData();

    GameStageData() {
    }

    public Collection<String> getStages() {
        return this.getStages(CommonConfig.listEffect);
    }

    @Override
    public Collection<String> getStages(@NotNull GameStageEffect effect) {
        HashSet list;
        HashSet hashSet = list = effect.isPlayerEffect() ? new HashSet(this.playerStageData.getStages()) : new HashSet();
        if (effect.isTeamEffect()) {
            list.addAll(this.teamStageData.getStages());
        }
        return Collections.unmodifiableCollection(list);
    }

    public boolean hasStage(@NotNull String stage) {
        return this.hasStage(stage, CommonConfig.checkEffect);
    }

    @Override
    public boolean hasStage(@NotNull String stage, @NotNull GameStageEffect effect) {
        return effect.isPlayerEffect() && this.playerStageData.hasStage(stage) || effect.isTeamEffect() && this.teamStageData.hasStage(stage);
    }

    public void addStage(@NotNull String stage) {
        this.addStage(stage, CommonConfig.changeEffect);
    }

    @Override
    public void addStage(@NotNull String stage, @NotNull GameStageEffect effect) {
        if (effect.isPlayerEffect()) {
            this.playerStageData.addStage(stage);
        }
        if (effect.isTeamEffect()) {
            this.teamStageData.addStage(stage);
        }
    }

    public void removeStage(@NotNull String stage) {
        this.removeStage(stage, CommonConfig.changeEffect);
    }

    @Override
    public void removeStage(@NotNull String stage, @NotNull GameStageEffect effect) {
        if (effect.isPlayerEffect()) {
            this.playerStageData.removeStage(stage);
        }
        if (effect.isTeamEffect()) {
            this.teamStageData.removeStage(stage);
        }
    }

    public void clear() {
        this.clear(CommonConfig.changeEffect);
    }

    @Override
    public void clear(@NotNull GameStageEffect effect) {
        if (effect.isPlayerEffect()) {
            this.playerStageData.clear();
        }
        if (effect.isTeamEffect()) {
            this.teamStageData.clear();
        }
    }

    public void readFromNBT(CompoundTag compoundTag) {
        this.playerStageData.readFromNBT(compoundTag);
    }

    public CompoundTag writeToNBT() {
        return this.playerStageData.writeToNBT();
    }
}

