/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.scsupercraft.teamstages.data.TeamStageHelper;
import dev.scsupercraft.teamstages.util.FtbUtil;
import java.util.stream.Collectors;
import net.darkhax.gamestages.command.StageArgumentType;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TeamStageCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder commandLiteral = Commands.m_82127_((String)"teamstage");
        commandLiteral.then(TeamStageCommands.createCommands(false));
        commandLiteral.then(TeamStageCommands.createCommands(true));
        LiteralCommandNode command = dispatcher.register(commandLiteral);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ts").redirect((CommandNode)command));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"gs").redirect(dispatcher.getRoot().getChild("gamestage")));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createCommand(String key, int permissions, boolean forTeam, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        RequiredArgumentBuilder targetArg = forTeam ? Commands.m_82129_((String)"target", (ArgumentType)TeamArgument.create()) : Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).executes(commandNoPlayer)).then(targetArg.executes(command));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createSilentStageCommand(String key, int permissions, boolean forTeam, Command<CommandSourceStack> command, Command<CommandSourceStack> silent) {
        RequiredArgumentBuilder targetArg = forTeam ? Commands.m_82129_((String)"target", (ArgumentType)TeamArgument.create()) : Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(targetArg.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)).then(Commands.m_82129_((String)"silent", (ArgumentType)BoolArgumentType.bool()).executes(silent))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createStageCommand(String key, int permissions, boolean forTeam, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        RequiredArgumentBuilder targetArg = forTeam ? Commands.m_82129_((String)"target", (ArgumentType)TeamArgument.create()) : Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(commandNoPlayer))).then(targetArg.then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createCommands(boolean forTeam) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)(forTeam ? "team" : "player"));
        command.then(TeamStageCommands.createSilentStageCommand("add", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, false, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, true, forTeam))));
        command.then(TeamStageCommands.createCommand("all", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.grantAll((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.grantAll((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createStageCommand("check", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.checkStage((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.checkStage((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createCommand("clear", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.clearStages((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.clearStages((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createCommand("info", 0, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.getStageInfo((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.getStageInfo((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createSilentStageCommand("remove", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, false, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, true, forTeam))));
        return command;
    }

    public static int grantAll(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (forTeam) {
            Team team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam((Player)source.m_81375_());
            TeamStageHelper.TeamHelper helper = TeamStageHelper.team();
            IStageData data = helper.getTeamData(team);
            if (team == null || data == null) {
                return 1;
            }
            helper.addStage(team, TeamStageHelper.getKnownStages().toArray(new String[0]));
            for (ServerPlayer player : team.getOnlineMembers()) {
                player.m_5661_((Component)Component.m_237115_((String)"commands.gamestage.all.target"), false);
                if (player == source.m_81373_()) continue;
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.all.sender", (Object[])new Object[]{player.m_5446_()}), true);
            }
        } else {
            ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
            TeamStageHelper.PlayerHelper helper = TeamStageHelper.player();
            IStageData data = helper.getPlayerData((Player)player);
            if (data == null) {
                return 1;
            }
            helper.addStage(player, TeamStageHelper.getKnownStages().toArray(new String[0]));
            player.m_5661_((Component)Component.m_237115_((String)"commands.gamestage.all.target"), false);
            if (player != source.m_81373_()) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.all.sender", (Object[])new Object[]{player.m_5446_()}), true);
            }
        }
        return 1;
    }

    public static int checkStage(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String stage = StageArgumentType.getStage(context, (String)"stage");
        if (forTeam) {
            Team team;
            Team team2 = team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam((Player)source.m_81375_());
            if (team == null) {
                return 1;
            }
            boolean hasStage = TeamStageHelper.team().hasStage(team, stage);
            source.m_288197_(() -> Component.m_237110_((String)(hasStage ? "commands.gamestage.check.success" : "commands.gamestage.check.failure"), (Object[])new Object[]{team.getShortName(), stage}), false);
            return hasStage ? 1 : 0;
        }
        ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
        boolean hasStage = TeamStageHelper.player().hasStage((Player)player, stage);
        source.m_288197_(() -> Component.m_237110_((String)(hasStage ? "commands.gamestage.check.success" : "commands.gamestage.check.failure"), (Object[])new Object[]{player.m_5446_(), stage}), false);
        return hasStage ? 1 : 0;
    }

    public static int clearStages(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (forTeam) {
            Team team;
            Team team2 = team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam((Player)source.m_81375_());
            if (team == null) {
                return 1;
            }
            int removedStages = TeamStageHelper.team().clearStages(team);
            for (ServerPlayer player : team.getOnlineMembers()) {
                player.m_5661_((Component)Component.m_237110_((String)"commands.gamestage.clear.target", (Object[])new Object[]{removedStages}), false);
                if (player == source.m_81373_()) continue;
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.clear.sender", (Object[])new Object[]{removedStages, player.m_5446_()}), true);
            }
        } else {
            ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
            int removedStages = TeamStageHelper.player().clearStages(player);
            player.m_5661_((Component)Component.m_237110_((String)"commands.gamestage.clear.target", (Object[])new Object[]{removedStages}), false);
            if (player != source.m_81373_()) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.clear.sender", (Object[])new Object[]{removedStages, player.m_5446_()}), true);
            }
        }
        return 1;
    }

    public static int getStageInfo(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        String infoOwner;
        IStageData data;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (forTeam) {
            Team team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam((Player)source.m_81375_());
            data = TeamStageHelper.team().getTeamData(team);
            infoOwner = team != null ? team.getShortName() : "unknown";
        } else {
            ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
            data = TeamStageHelper.player().getPlayerData((Player)player);
            infoOwner = player.m_6302_();
        }
        if (data == null || data.getStages().isEmpty()) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.info.empty", (Object[])new Object[]{infoOwner}), false);
            return 1;
        }
        String stageInfo = data.getStages().stream().map(Object::toString).collect(Collectors.joining(", "));
        source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.info.stages", (Object[])new Object[]{infoOwner, stageInfo}), false);
        return 1;
    }

    private static int changeStages(CommandContext<CommandSourceStack> context, boolean adding, boolean hasSilentArg, boolean forTeam) throws CommandSyntaxException {
        boolean silent;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String stage = StageArgumentType.getStage(context, (String)"stage");
        boolean bl = silent = hasSilentArg && BoolArgumentType.getBool(context, (String)"silent");
        if (forTeam) {
            Team team = TeamArgument.get(context, (String)"target");
            TeamStageHelper.TeamHelper helper = TeamStageHelper.team();
            if (helper.getTeamData(team) == null || adding == helper.hasStage(team, stage)) {
                return 1;
            }
            if (adding) {
                helper.addStage(team, stage);
            } else {
                helper.removeStage(team, stage);
            }
            if (silent) {
                return 1;
            }
            for (ServerPlayer player : team.getOnlineMembers()) {
                player.m_5661_((Component)Component.m_237110_((String)(adding ? "commands.gamestage.add.target" : "commands.gamestage.remove.target"), (Object[])new Object[]{stage}), false);
                if (player == source.m_81373_()) continue;
                source.m_288197_(() -> Component.m_237110_((String)(adding ? "commands.gamestage.add.sender" : "commands.gamestage.remove.sender"), (Object[])new Object[]{stage, player.m_5446_()}), true);
            }
        } else {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"target");
            TeamStageHelper.PlayerHelper helper = TeamStageHelper.player();
            if (helper.getPlayerData((Player)player) == null || adding == helper.hasStage((Player)player, stage)) {
                return 1;
            }
            if (adding) {
                helper.addStage(player, stage);
            } else {
                helper.removeStage(player, stage);
            }
            if (silent) {
                return 1;
            }
            player.m_5661_((Component)Component.m_237110_((String)(adding ? "commands.gamestage.add.target" : "commands.gamestage.remove.target"), (Object[])new Object[]{stage}), false);
            if (player != source.m_81373_()) {
                source.m_288197_(() -> Component.m_237110_((String)(adding ? "commands.gamestage.add.sender" : "commands.gamestage.remove.sender"), (Object[])new Object[]{stage, player.m_5446_()}), true);
            }
        }
        return 1;
    }
}

