/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialisation.resolver.basic;

import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialisation.GenericClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SetCodecResolver
implements CodecResolver {
    @Override
    public boolean supportsValue(GenericClass<?> genericClass) {
        return this.isSet(genericClass.clazz) && (this.findConstructor(genericClass.clazz).isPresent() || genericClass.clazz.getTypeName().equals(Set.class.getTypeName()));
    }

    @Override
    @NotNull
    public <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
        return (CodecHolder)Utils.cast(this.resolveSetCodec((GenericClass)Utils.cast(genericClass)));
    }

    @NotNull
    private <T, C extends Set<T>> CodecHolder<C> resolveSetCodec(GenericClass<C> genericClass) {
        GenericClass element = (GenericClass)Utils.cast(genericClass.typeParameterIterator().next());
        CodecHolder elementCodec = CodecHelper.getCodec(element);
        if (genericClass.clazz.getTypeName().equals(Set.class.getTypeName())) {
            return (CodecHolder)Utils.cast(CodecHolder.unmodifiableSet(elementCodec));
        }
        Constructor constructor = this.findConstructor(genericClass.clazz).orElseThrow();
        return CodecHolder.set(elementCodec).xmap(list -> {
            try {
                constructor.setAccessible(true);
                return (Set)constructor.newInstance(list);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, list -> list);
    }

    private <T> Optional<Constructor<T>> findConstructor(Class<T> tClass) {
        return (Optional)Utils.cast(Arrays.stream(tClass.getDeclaredConstructors()).filter(this::isValidConstructor).findFirst());
    }

    private boolean isSet(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        if (clazz == Set.class || Arrays.stream(clazz.getInterfaces()).anyMatch(this::isSet)) {
            return true;
        }
        return this.isSet(clazz.getSuperclass());
    }

    private boolean isValidConstructor(Constructor<?> constructor) {
        Parameter[] parameters = constructor.getParameters();
        if (parameters.length != 1) {
            return false;
        }
        Parameter parameter = parameters[0];
        return parameter.getType() == Collection.class;
    }
}

