/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialisation.resolver.basic;

import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialisation.GenericClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class MapCodecResolver
implements CodecResolver {
    @Override
    public boolean supportsValue(GenericClass<?> genericClass) {
        return this.isMap(genericClass.clazz) && (this.findConstructor(genericClass.clazz).isPresent() || genericClass.clazz.getTypeName().equals(Map.class.getTypeName()));
    }

    @Override
    @NotNull
    public <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
        return (CodecHolder)Utils.cast(this.resolveMapCodec((GenericClass)Utils.cast(genericClass)));
    }

    @NotNull
    private <K, V, C extends Map<K, V>> CodecHolder<C> resolveMapCodec(GenericClass<C> genericClass) {
        Iterator<GenericClass<?>> typeParameters = genericClass.typeParameterIterator();
        GenericClass key = (GenericClass)Utils.cast(typeParameters.next());
        CodecHolder keyCodec = CodecHelper.getCodec(key);
        GenericClass value = (GenericClass)Utils.cast(typeParameters.next());
        CodecHolder valueCodec = CodecHelper.getCodec(value);
        if (genericClass.clazz.getTypeName().equals(Map.class.getTypeName())) {
            return (CodecHolder)Utils.cast(CodecHolder.unmodifiableMap(keyCodec, valueCodec));
        }
        Constructor constructor = this.findConstructor(genericClass.clazz).orElseThrow();
        return CodecHolder.map(keyCodec, valueCodec).xmap(map -> {
            try {
                constructor.setAccessible(true);
                return (Map)constructor.newInstance(map);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, map -> map);
    }

    private <T> Optional<Constructor<T>> findConstructor(Class<T> tClass) {
        return (Optional)Utils.cast(Arrays.stream(tClass.getDeclaredConstructors()).filter(this::isValidConstructor).findFirst());
    }

    private boolean isMap(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        if (clazz == Map.class || Arrays.stream(clazz.getInterfaces()).anyMatch(this::isMap)) {
            return true;
        }
        return this.isMap(clazz.getSuperclass());
    }

    private boolean isValidConstructor(Constructor<?> constructor) {
        Parameter[] parameters = constructor.getParameters();
        if (parameters.length != 1) {
            return false;
        }
        Parameter parameter = parameters[0];
        return parameter.getType() == Map.class;
    }
}

