/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialisation.resolver.basic;

import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialisation.GenericClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ListCodecResolver
implements CodecResolver {
    @Override
    public boolean supportsValue(GenericClass<?> genericClass) {
        return this.isList(genericClass.clazz) && (this.findConstructor(genericClass.clazz).isPresent() || genericClass.clazz.getTypeName().equals(List.class.getTypeName()));
    }

    @Override
    @NotNull
    public <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
        return (CodecHolder)Utils.cast(this.resolveListCodec((GenericClass)Utils.cast(genericClass)));
    }

    @NotNull
    private <T, C extends List<T>> CodecHolder<C> resolveListCodec(GenericClass<C> genericClass) {
        GenericClass element = (GenericClass)Utils.cast(genericClass.typeParameterIterator().next());
        CodecHolder elementCodec = CodecHelper.getCodec(element);
        if (genericClass.clazz.getTypeName().equals(List.class.getTypeName())) {
            return (CodecHolder)Utils.cast(CodecHolder.unmodifiableList(elementCodec));
        }
        Constructor constructor = this.findConstructor(genericClass.clazz).orElseThrow();
        return CodecHolder.list(elementCodec).xmap(list -> {
            try {
                constructor.setAccessible(true);
                return (List)constructor.newInstance(list);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, list -> list);
    }

    private <T> Optional<Constructor<T>> findConstructor(Class<T> tClass) {
        return (Optional)Utils.cast(Arrays.stream(tClass.getDeclaredConstructors()).filter(this::isValidConstructor).findFirst());
    }

    private boolean isList(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        if (clazz == List.class || Arrays.stream(clazz.getInterfaces()).anyMatch(this::isList)) {
            return true;
        }
        return this.isList(clazz.getSuperclass());
    }

    private boolean isValidConstructor(Constructor<?> constructor) {
        Parameter[] parameters = constructor.getParameters();
        if (parameters.length != 1) {
            return false;
        }
        Parameter parameter = parameters[0];
        return parameter.getType() == Collection.class;
    }
}

