/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.util;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.scsupercraft.mc.libraries.corelib.CoreLib;
import dev.scsupercraft.mc.libraries.corelib.api.data.SyncedData;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public class Synchronisation {
    private static final Map<class_2960, SyncedObject<?>> SYNCED_OBJECTS = new HashMap();

    @ApiStatus.AvailableSince(value="1.0.0")
    public static <T> void setup(SyncedData<T> syncedData, CodecHolder<T> codecHolder) {
        if (!SYNCED_OBJECTS.containsKey(syncedData.getSyncId())) {
            SYNCED_OBJECTS.put(syncedData.getSyncId(), new SyncedObject<T>(syncedData, codecHolder));
        }
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void synchronise(SyncedData<?> syncedData) {
        Synchronisation.synchronise(SYNCED_OBJECTS.get(syncedData.getSyncId()));
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void synchronise(SyncedData<?> syncedData, class_3222 client) {
        Synchronisation.synchronise(SYNCED_OBJECTS.get(syncedData.getSyncId()), client);
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void synchronise(class_3222 client) {
        SYNCED_OBJECTS.values().forEach(obj -> Synchronisation.synchronise(obj, client));
    }

    private static void synchronise(SyncedObject<?> syncedObject) {
        CoreLib.LOGGER.info("Synchronising {} to all clients...", (Object)syncedObject.syncedData.getSyncId());
        syncedObject.sync();
    }

    private static void synchronise(SyncedObject<?> syncedObject, class_3222 client) {
        CoreLib.LOGGER.info("Synchronising {} to client {}...", (Object)syncedObject.syncedData.getSyncId(), (Object)client.method_7334().getName());
        syncedObject.sync(client);
    }

    private static <T> SyncedObject<T> get(class_2960 id) {
        return (SyncedObject)Utils.cast(SYNCED_OBJECTS.get(id));
    }

    private Synchronisation() {
    }

    static {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, DataSyncPacket.PACKET_ID, DataSyncPacket.PACKET_CODEC, (packet, context) -> {
            SyncedData syncedData = Synchronisation.get(packet.id()).syncedData();
            syncedData.setSyncedData(packet.data());
            CoreLib.LOGGER.info("Synchronised {} with the server.", (Object)packet.id());
        });
        PlayerEvent.PLAYER_JOIN.register(Synchronisation::synchronise);
    }

    private record SyncedObject<T>(SyncedData<T> syncedData, CodecHolder<T> codecHolder) {
        private DataSyncPacket<T> createPacket() {
            return new DataSyncPacket(this.syncedData.getSyncId(), this.syncedData.getData());
        }

        private void sync() {
            if (CoreLib.server == null) {
                return;
            }
            NetworkManager.sendToPlayers((Iterable)CoreLib.server.method_3760().method_14571(), this.createPacket());
        }

        private void sync(class_3222 client) {
            if (CoreLib.server == null || client == null) {
                return;
            }
            NetworkManager.sendToPlayer((class_3222)client, this.createPacket());
        }
    }

    private record DataSyncPacket<T>(class_2960 id, T data) implements class_8710
    {
        public static final class_8710.class_9154<DataSyncPacket<?>> PACKET_ID = new class_8710.class_9154(class_2960.method_60655((String)"corelib", (String)"data_sync"));
        public static final class_9139<class_2540, DataSyncPacket<?>> PACKET_CODEC = class_9139.method_56438((value, buf) -> {
            buf.method_10812(value.id);
            SyncedObject synced = Synchronisation.get(value.id);
            synced.codecHolder().packetCodec().encode(buf, value.data);
        }, buf -> {
            class_2960 id = buf.method_10810();
            return new DataSyncPacket<Object>(id, Synchronisation.get(id).codecHolder().packetCodec().decode(buf));
        });

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

