/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.serialisation;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.EitherCodec;
import com.mojang.serialization.codecs.PairCodec;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.Codecs;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialisation.codec.PairPacketCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public record CodecHolder<T>(Codec<T> codec, class_9139<ByteBuf, T> packetCodec) {
    @ApiStatus.AvailableSince(value="1.0.0")
    public static <T> CodecHolder<T> of(Codec<T> codec, class_9139<? extends ByteBuf, T> packetCodec) {
        return new CodecHolder<T>(codec, packetCodec);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <T extends Enum<T>> CodecHolder<T> enumeration(Class<T> enumClass) {
        return CodecHolder.of(Codec.STRING.xmap(string -> Enum.valueOf(enumClass, string), Enum::name), class_9135.field_48554.method_56432(string -> Enum.valueOf(enumClass, string), Enum::name));
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <E> CodecHolder<E[]> array(CodecHolder<E> codecHolder) {
        return CodecHolder.list(codecHolder).xmap(list -> (Object[])Utils.cast(list.toArray()), List::of);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <E, C extends Collection<E>> CodecHolder<C> collection(IntFunction<C> factory, CodecHolder<E> codecHolder) {
        return CodecHolder.of(Codec.list(codecHolder.codec).xmap(list -> {
            Collection collection = (Collection)factory.apply(list.size());
            collection.addAll(list);
            return collection;
        }, ArrayList::new), class_9135.method_56376(factory, codecHolder.packetCodec));
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <E> CodecHolder<List<E>> list(CodecHolder<E> codecHolder) {
        return CodecHolder.collection(ArrayList::new, codecHolder);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <E> CodecHolder<List<E>> unmodifiableList(CodecHolder<E> codecHolder) {
        return CodecHolder.list(codecHolder).xmap(Collections::unmodifiableList, l -> l);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <E> CodecHolder<Set<E>> set(CodecHolder<E> codecHolder) {
        return CodecHolder.collection(HashSet::new, codecHolder);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <E> CodecHolder<Set<E>> unmodifiableSet(CodecHolder<E> codecHolder) {
        return CodecHolder.set(codecHolder).xmap(Collections::unmodifiableSet, s -> s);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <K, V, M extends Map<K, V>> CodecHolder<M> map(IntFunction<M> factory, CodecHolder<K> keyCodecHolder, CodecHolder<V> valueCodecHolder) {
        return CodecHolder.of(Codec.unboundedMap(keyCodecHolder.codec, valueCodecHolder.codec).xmap(map -> {
            Map map1 = (Map)factory.apply(map.size());
            map1.putAll(map);
            return map1;
        }, m -> m), class_9135.method_56377(factory, keyCodecHolder.packetCodec, valueCodecHolder.packetCodec));
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <K, V> CodecHolder<Map<K, V>> map(CodecHolder<K> keyCodecHolder, CodecHolder<V> valueCodecHolder) {
        return CodecHolder.map(HashMap::new, keyCodecHolder, valueCodecHolder);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <K, V> CodecHolder<Map<K, V>> unmodifiableMap(CodecHolder<K> keyCodecHolder, CodecHolder<V> valueCodecHolder) {
        return CodecHolder.map(keyCodecHolder, valueCodecHolder).xmap(Collections::unmodifiableMap, m -> m);
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <T> CodecHolder<Optional<T>> optional(CodecHolder<T> codecHolder) {
        return CodecHolder.of(Codecs.method_57155(codecHolder.codec), class_9135.method_56382(codecHolder.packetCodec));
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <L, R> CodecHolder<Either<L, R>> either(CodecHolder<L> leftCodecHolder, CodecHolder<R> rightCodecHolder) {
        return CodecHolder.of(new EitherCodec(leftCodecHolder.codec, rightCodecHolder.codec), class_9135.method_57995(leftCodecHolder.packetCodec, rightCodecHolder.packetCodec));
    }

    @ApiStatus.AvailableSince(value="1.0.1")
    public static <F, S> CodecHolder<Pair<F, S>> pair(CodecHolder<F> firstCodecHolder, CodecHolder<S> secondCodecHolder) {
        return CodecHolder.of(new PairCodec(firstCodecHolder.codec.fieldOf("first").codec(), secondCodecHolder.codec.fieldOf("second").codec()), new PairPacketCodec(firstCodecHolder.packetCodec, secondCodecHolder.packetCodec));
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public <U> CodecHolder<U> xmap(Function<? super T, ? extends U> to, Function<? super U, ? extends T> from) {
        return new CodecHolder<T>(this.codec.xmap(to, from), this.packetCodec.method_56432(to, from));
    }
}

