/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.data;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.scsupercraft.mc.libraries.corelib.CoreLib;
import dev.scsupercraft.mc.libraries.corelib.api.data.SaveData;
import dev.scsupercraft.mc.libraries.corelib.api.data.SyncedWorldSaveData;
import dev.scsupercraft.mc.libraries.corelib.api.event.WorldSaveDataEvent;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHolder;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="1.0.0")
public sealed class WorldSaveData<T>
extends SaveData<T>
permits SyncedWorldSaveData {
    private static final Set<WorldSaveData<?>> WORLD_SAVABLE_SET = new HashSet();
    private static boolean loaded = false;

    @ApiStatus.AvailableSince(value="1.0.0")
    public WorldSaveData(Supplier<@NotNull T> defaultValue, CodecHolder<T> codecHolder, Function<MinecraftServer, File> fileGetter, SaveData.Type type) {
        super(defaultValue, codecHolder, () -> (File)fileGetter.apply(CoreLib.server), type);
        WORLD_SAVABLE_SET.add(this);
    }

    public static boolean isLoaded() {
        return loaded;
    }

    private static void loadAll() {
        WORLD_SAVABLE_SET.forEach(SaveData::load);
    }

    private static void saveAll() {
        WORLD_SAVABLE_SET.forEach(SaveData::save);
    }

    static {
        LifecycleEvent.SERVER_BEFORE_START.register(s -> {
            CoreLib.server = s;
            WorldSaveData.loadAll();
            loaded = true;
            ((WorldSaveDataEvent.LoadEvent)WorldSaveDataEvent.LOAD_EVENT.invoker()).onLoaded((MinecraftServer)s);
        });
        LifecycleEvent.SERVER_STOPPED.register(s -> {
            WorldSaveData.saveAll();
            CoreLib.server = null;
            loaded = false;
            ((WorldSaveDataEvent.SaveEvent)WorldSaveDataEvent.SAVE_EVENT.invoker()).onSaved((MinecraftServer)s);
        });
    }
}

