package dev.scsupercraft.mc.libraries.corelib.serialisation.resolver.unique;

import com.mojang.datafixers.util.Either;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialisation.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialisation.GenericClass;
import org.jetbrains.annotations.NotNull;

import java.util.Iterator;

/**
 * A codec resolver for {@link Either}s.
 */
public final class EitherCodecResolver implements CodecResolver {
	@Override
	public boolean supportsValue(GenericClass<?> genericClass) {
		return genericClass.clazz == Either.class;
	}

	@Override
	public @NotNull <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
		Iterator<? extends GenericClass<?>> iterator = genericClass.typeParameterIterator();
		CodecHolder<?> holderLeft = CodecHelper.getCodec(iterator.next());
		CodecHolder<?> holderRight = CodecHelper.getCodec(iterator.next());

		return Utils.cast(CodecHolder.either(holderLeft, holderRight));
	}

	/**
	 * Creates a new {@link EitherCodecResolver}.
	 */
	public EitherCodecResolver() {

	}
}
