package dev.scsupercraft.mc.libraries.corelib.api.serialisation;

import com.mojang.authlib.GameProfile;
import dev.architectury.fluid.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalLong;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6862;
import net.minecraft.class_8824;

/**
 * A collection of pre-made {@link CodecHolder}s.
 */
@ApiStatus.AvailableSince("1.0.0")
public class CodecHolders {
	private CodecHolders() {}

	/** A codec holder for {@code byte} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Byte> BYTE = CodecHolder.of(Codecs.BYTE, PacketCodecs.field_48548);

	/** A codec holder for {@code short} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Short> SHORT = CodecHolder.of(Codecs.SHORT, PacketCodecs.field_48549);

	/** A codec holder for {@code char} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Character> CHARACTER = CodecHolder.of(Codecs.CHARACTER, PacketCodecs.CHARACTER);

	/** A codec holder for {@code boolean} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Boolean> BOOLEAN = CodecHolder.of(Codecs.BOOL, PacketCodecs.field_48547);

	/** A codec holder for {@link String} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<String> STRING = CodecHolder.of(Codecs.STRING, PacketCodecs.field_48554);

	/** A codec holder for {@code int} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Integer> INTEGER = CodecHolder.of(Codecs.INT, PacketCodecs.field_49675);

	/** A codec holder for {@code long} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Long> LONG = CodecHolder.of(Codecs.LONG, PacketCodecs.field_54505);

	/** A codec holder for {@code float} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Float> FLOAT = CodecHolder.of(Codecs.FLOAT, PacketCodecs.field_48552);

	/** A codec holder for {@code double} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Double> DOUBLE = CodecHolder.of(Codecs.DOUBLE, PacketCodecs.field_48553);

	/** A codec holder for {@link BigInteger} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<BigInteger> BIG_INTEGER = CodecHolder.of(Codecs.BIG_INTEGER, PacketCodecs.BIG_INTEGER);

	/** A codec holder for {@link BigDecimal} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<BigDecimal> BIG_DECIMAL = CodecHolder.of(Codecs.BIG_DECIMAL, PacketCodecs.BIG_DECIMAL);

	/** A codec holder for {@link OptionalLong} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<OptionalLong> OPTIONAL_LONG = CodecHolder.of(Codecs.OPTIONAL_LONG, PacketCodecs.OPTIONAL_LONG);

	/** A codec holder for {@link UUID} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<UUID> UUID = CodecHolder.of(Codecs.UUID, PacketCodecs.UUID);

	/** A codec holder for {@link class_1799} instances. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_1799> ITEM_STACK = CodecHolder.of(class_1799.field_24671, class_1799.field_48349);

	/** A codec holder for {@link FluidStack} instances. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<FluidStack> FLUID_STACK = CodecHolder.of(FluidStack.CODEC, FluidStack.STREAM_CODEC);

	/** A codec holder for {@link class_2338} positions. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_2338> BLOCK_POS = CodecHolder.of(class_2338.field_25064, class_2338.field_48404);

	/** A codec holder for {@link class_4208} values, combining dimension and position. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_4208> GLOBAL_POS = CodecHolder.of(class_4208.field_25066, class_4208.field_48451);

	/** A codec holder for {@link GameProfile} instances, typically used for player identity. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<GameProfile> GAME_PROFILE = CodecHolder.of(Codecs.GAME_PROFILE, PacketCodecs.field_49679);

	/** A codec holder for {@link class_2561} components, including chat and UI text. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_2561> TEXT = CodecHolder.of(class_8824.field_46597, class_8824.field_49668);

	/** A codec holder for {@link class_2960} values, used for differentiating objects from multiple mods. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_2960> IDENTIFIER = CodecHolder.of(class_2960.field_25139, class_2960.field_48267);

	/** A codec holder for {@link class_2487} values, representing structured NBT data. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_2487> NBT_COMPOUND = CodecHolder.of(class_2487.field_25128, PacketCodecs.field_48556);

	/** A codec holder for {@link class_2520} values, representing any NBT element. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_2520> NBT_ELEMENT = CodecHolder.of(Codecs.field_60980, PacketCodecs.field_48555);

	/** A codec holder for {@link class_5321} values, representing registry entries. */
	@ApiStatus.AvailableSince("1.0.0")
	@SuppressWarnings("rawtypes")
	public static final CodecHolder<class_5321> REGISTRY_KEY = CodecHolder.of(Codecs.REGISTRY_KEY, PacketCodecs.REGISTRY_KEY);

	/** A codec holder for {@link class_6862} values, representing tag references. */
	@ApiStatus.AvailableSince("1.0.0")
	@SuppressWarnings("rawtypes")
	public static final CodecHolder<class_6862> TAG_KEY = CodecHolder.of(Codecs.TAG_KEY, PacketCodecs.TAG_KEY);

	/** A codec holder for {@link Vector3f} values, representing 3D float vectors. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Vector3f> VECTOR_3F = CodecHolder.of(Codecs.field_40723, PacketCodecs.field_48558);

	/** A codec holder for {@link Quaternionf} values, representing rotation quaternions. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<Quaternionf> QUATERNION_F = CodecHolder.of(Codecs.field_42265, PacketCodecs.field_48559);

	/** A codec holder for {@link class_6017} values, used for ranged or constant integer values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final CodecHolder<class_6017> INT_PROVIDER = CodecHolder.of(class_6017.field_29946, PacketCodecs.INT_PROVIDER);
}
