/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialization.resolver.basic;

import com.mojang.serialization.Codec;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialization.GenericClass;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public final class EnumCodecResolver
implements CodecResolver {
    @Override
    public boolean supportsValue(GenericClass<?> genericClass) {
        return genericClass.clazz.isEnum();
    }

    @Override
    @NotNull
    public <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
        return (CodecHolder)Utils.cast(this.fromEnum((Class)Utils.cast(genericClass.clazz)));
    }

    private <T extends Enum<T>> CodecHolder<T> fromEnum(Class<T> tClass) {
        if (!tClass.isEnum()) {
            throw new IllegalArgumentException("You can only create an enum codec from a enum!");
        }
        return new CodecHolder<T>(this.codecFromEnum(tClass), this.packetCodecFromEnum(tClass));
    }

    private <T extends Enum<T>> Codec<T> codecFromEnum(Class<T> tClass) {
        return Codec.STRING.xmap(string -> Enum.valueOf(tClass, string), Enum::name);
    }

    private <T extends Enum<T>> class_9139<ByteBuf, T> packetCodecFromEnum(Class<T> tClass) {
        return class_9135.field_48554.method_56432(string -> Enum.valueOf(tClass, string), Enum::name);
    }
}

