/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialization;

import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class GenericClass<T> {
    public final GenericClass<?> parent;
    public final Class<T> clazz;
    public final Map<TypeVariable<Class<T>>, GenericClass<?>> typeParameters = new HashMap();
    public final boolean array;
    @Nullable
    public final AnnotatedType annotations;

    public static GenericClass<?> of(AnnotatedType annotatedType) {
        return GenericClass.of(annotatedType, null);
    }

    public static GenericClass<?> of(AnnotatedType annotatedType, GenericClass<?> parentType) {
        return GenericClass.of(annotatedType.getType(), annotatedType, parentType);
    }

    public static GenericClass<?> of(Type type, @Nullable AnnotatedType annotatedType) {
        return GenericClass.of(type, annotatedType, null);
    }

    public static GenericClass<?> of(Type type, @Nullable AnnotatedType annotatedType, GenericClass<?> parentType) {
        ParameterizedType parameterizedType;
        Type type2;
        WildcardType wildcardType;
        boolean array = false;
        if (type instanceof WildcardType && (wildcardType = (WildcardType)type).getUpperBounds().length > 0) {
            AnnotatedWildcardType annotatedWildcardType;
            type = wildcardType.getUpperBounds()[0];
            if (annotatedType instanceof AnnotatedWildcardType && (annotatedWildcardType = (AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds().length > 0) {
                annotatedType = annotatedWildcardType.getAnnotatedUpperBounds()[0];
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            type = genericArrayType.getGenericComponentType();
            if (annotatedType instanceof AnnotatedArrayType) {
                AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)annotatedType;
                annotatedType = annotatedArrayType.getAnnotatedGenericComponentType();
            }
            array = true;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return array ? new GenericClass(new GenericClass(clazz, null, parentType), annotatedType) : new GenericClass(clazz, annotatedType, parentType);
        }
        if (type instanceof ParameterizedType && (type2 = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            GenericClass genericClass;
            Class clazz = (Class)type2;
            if (annotatedType instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
                genericClass = new GenericClass(clazz, annotatedType, parentType, annotatedParameterizedType.getAnnotatedActualTypeArguments());
            } else {
                genericClass = new GenericClass(clazz, annotatedType, parentType, parameterizedType.getActualTypeArguments());
            }
            return array ? new GenericClass(genericClass, annotatedType) : genericClass;
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            GenericClass<?> genericClass = parentType;
            while (genericClass != null) {
                if (genericClass.typeParameters.containsKey(typeVariable)) {
                    return array ? new GenericClass(genericClass.typeParameters.get(typeVariable), annotatedType) : genericClass.typeParameters.get(typeVariable);
                }
                genericClass = genericClass.parent;
            }
        }
        throw new RuntimeException("Unsupported type: " + String.valueOf(type));
    }

    public GenericClass(GenericClass<T> arrayType, @Nullable AnnotatedType annotations) {
        this.parent = arrayType;
        this.clazz = arrayType.clazz;
        this.typeParameters.putAll(arrayType.typeParameters);
        this.array = true;
        this.annotations = annotations;
    }

    public GenericClass(Class<T> tClass, @Nullable AnnotatedType annotations) {
        this(tClass, annotations, null);
    }

    public GenericClass(Class<T> tClass, @Nullable AnnotatedType annotations, @Nullable GenericClass<?> parent) {
        this(tClass, annotations, parent, new Type[0]);
    }

    public GenericClass(Class<T> tClass, @Nullable AnnotatedType annotations, @Nullable GenericClass<?> parent, Type[] typeParameters) {
        this(tClass, annotations, parent, self -> {
            GenericClass[] resolved = new GenericClass[typeParameters.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                resolved[i] = GenericClass.of(typeParameters[i], null, self);
            }
            return resolved;
        });
    }

    public GenericClass(Class<T> tClass, @Nullable AnnotatedType annotations, @Nullable GenericClass<?> parent, AnnotatedType[] typeParameters) {
        this(tClass, annotations, parent, self -> {
            GenericClass[] resolved = new GenericClass[typeParameters.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                resolved[i] = GenericClass.of(typeParameters[i].getType(), typeParameters[i], self);
            }
            return resolved;
        });
    }

    public GenericClass(Class<T> tClass, @Nullable AnnotatedType annotations, @Nullable GenericClass<?> parent, Function<GenericClass<T>, GenericClass<?>[]> typeParameterProvider) {
        this.clazz = tClass;
        this.parent = parent;
        this.array = false;
        this.annotations = annotations;
        GenericClass<?>[] typeParameters = typeParameterProvider.apply(this);
        if (typeParameters.length != tClass.getTypeParameters().length) {
            throw new RuntimeException("Wrong amount of type parameters for class: " + String.valueOf(tClass) + " expected " + tClass.getTypeParameters().length + ", received " + typeParameters.length);
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            this.typeParameters.put(tClass.getTypeParameters()[i], typeParameters[i]);
        }
    }

    public Iterator<? extends GenericClass<?>> typeParameterIterator() {
        return Arrays.stream(this.clazz.getTypeParameters()).map(this.typeParameters::get).iterator();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "<", ">");
        sj.setEmptyValue("");
        for (TypeVariable<Class<T>> typeVariable : this.clazz.getTypeParameters()) {
            sj.add(this.typeParameters.get(typeVariable).toString());
        }
        return this.clazz.getTypeName() + String.valueOf(sj) + (this.array ? "[]" : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GenericClass)) {
            return super.equals(obj);
        }
        GenericClass other = (GenericClass)obj;
        if (this.clazz != other.clazz || this.array != other.array) {
            return false;
        }
        for (TypeVariable<Class<T>> typeVariable : this.typeParameters.keySet()) {
            GenericClass<?> genericClass1;
            GenericClass<?> genericClass = this.typeParameters.get(typeVariable);
            if (genericClass.equals(genericClass1 = other.typeParameters.get(typeVariable))) continue;
            return false;
        }
        return true;
    }
}

