/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.serialization;

import dev.architectury.platform.Platform;
import dev.scsupercraft.mc.libraries.corelib.CoreLib;
import dev.scsupercraft.mc.libraries.corelib.api.event.SerializationEvent;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialization.GenericClass;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public final class CodecHelper {
    private static final Set<CodecResolver> CODEC_RESOLVERS = new HashSet<CodecResolver>();

    @ApiStatus.AvailableSince(value="1.0.0")
    public static <T, U extends T> CodecHolder<U> getCodec(Class<T> tClass, Type ... types) {
        GenericClass<T> genericClass = new GenericClass<T>(tClass, null, null, types);
        return CodecHelper.getCodec(genericClass);
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static <T, U extends T> CodecHolder<U> getCodec(GenericClass<T> genericClass) {
        for (CodecResolver resolver : CodecHelper.getResolvers()) {
            if (!resolver.supportsValue(genericClass)) continue;
            if (Platform.isDevelopmentEnvironment()) {
                CoreLib.LOGGER.info("Using {} to resolve codec for class {}", (Object)resolver.getClass().getSimpleName(), genericClass);
            }
            return (CodecHolder)Utils.cast(resolver.resolveCodec(genericClass));
        }
        throw new RuntimeException("Failed to resolve codec for class " + String.valueOf(genericClass) + ", no codec resolvers support the provided type");
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static Set<CodecResolver> getResolvers() {
        return Collections.unmodifiableSet(CODEC_RESOLVERS);
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void refreshCodecResolvers() {
        ((SerializationEvent.RegisterCodecResolverEvent)SerializationEvent.REGISTER_CODEC_RESOLVER_EVENT.invoker()).register(CODEC_RESOLVERS::add);
    }

    private CodecHelper() {
    }
}

