package dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique;

import dev.scsupercraft.mc.libraries.corelib.annotations.RegistryRef;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolders;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialization.GenericClass;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

/**
 * A codec resolver for {@link class_6862}s
 * <br><br>
 * Annotate a type with {@link RegistryRef} to tell the codec resolver what registry the tag is for.
 * Not required but highly recommended.
 * <br><br>
 * If not included upon serialization, the registry ref will be serialized with the tag instead.
 * <br><br>
 * Without @RegistryRef("block") - {"data": {"registryRef": "minecraft:block", id: "minecraft:needs_iron_tool"}}
 * <br>
 * With @RegistryRef("block") - {"data": "#minecraft:needs_iron_tool"}
 */
public final class TagKeyCodecResolver implements CodecResolver {
	@Override
	public boolean supportsValue(GenericClass<?> genericClass) {
		return genericClass.clazz == class_6862.class;
	}

	@Override
	public @NotNull <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
		if (genericClass.annotations == null || !genericClass.annotations.isAnnotationPresent(RegistryRef.class)) return Utils.cast(CodecHolders.TAG_KEY);
		RegistryRef registryRef = genericClass.annotations.getAnnotation(RegistryRef.class);
		class_5321<class_2378<Object>> registryKey = class_5321.method_29180(class_2960.method_60655(registryRef.namespace(), registryRef.value()));

		return Utils.cast(new CodecHolder<>(
				class_6862.method_40093(registryKey),
				class_6862.method_64143(registryKey)
		));
	}

	/**
	 * Creates a new {@link TagKeyCodecResolver}.
	 */
	public TagKeyCodecResolver() {

	}
}
