package dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique;

import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialization.GenericClass;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import net.minecraft.class_5699;
import net.minecraft.class_9135;

/**
 * A codec resolver for {@link Optional}s.
 */
public final class OptionalCodecResolver implements CodecResolver {
	@Override
	public boolean supportsValue(GenericClass<?> genericClass) {
		return genericClass.clazz == Optional.class;
	}

	@Override
	public @NotNull <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
		CodecHolder<?> holder = CodecHelper.getCodec(genericClass.typeParameterIterator().next());
		return Utils.cast(new CodecHolder<>(class_5699.method_57155(holder.codec()), Utils.cast(class_9135.method_56382(holder.packetCodec()))));
	}

	/**
	 * Creates a new {@link OptionalCodecResolver}.
	 */
	public OptionalCodecResolver() {

	}
}
