package dev.scsupercraft.mc.libraries.corelib.listener;

import com.mojang.authlib.GameProfile;
import dev.scsupercraft.mc.libraries.corelib.api.event.SerializationEvent;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.*;
import dev.scsupercraft.mc.libraries.corelib.serialization.resolver.basic.*;
import dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique.EitherCodecResolver;
import dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique.OptionalCodecResolver;
import dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique.PairCodecResolver;
import dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique.TagKeyCodecResolver;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6017;

/**
 * An event listener used by CoreLib to register its own standard codecs and codec resolvers.
 */
public final class SerializationEventListener {
	/**
	 * Called by CoreLib to register its serialization event listeners.
	 */
	public static void init() {
		SerializationEvent.REGISTER_STANDARD_CODEC_EVENT.register(SerializationEventListener::registerStandardCodecs);
		SerializationEvent.REGISTER_CODEC_RESOLVER_EVENT.register(SerializationEventListener::registerCodecResolvers);
	}

	private static void registerStandardCodecs(BiConsumer<Class<?>, CodecHolder<?>> registry) {
		registry.accept(         Byte.class, CodecHolders.BYTE);
		registry.accept(        Short.class, CodecHolders.SHORT);
		registry.accept(    Character.class, CodecHolders.CHARACTER);
		registry.accept(      Boolean.class, CodecHolders.BOOLEAN);
		registry.accept(       String.class, CodecHolders.STRING);
		registry.accept(      Integer.class, CodecHolders.INTEGER);
		registry.accept(         Long.class, CodecHolders.LONG);
		registry.accept(        Float.class, CodecHolders.FLOAT);
		registry.accept(       Double.class, CodecHolders.DOUBLE);
		registry.accept(   BigInteger.class, CodecHolders.BIG_INTEGER);
		registry.accept(   BigDecimal.class, CodecHolders.BIG_DECIMAL);
		registry.accept( OptionalLong.class, CodecHolders.OPTIONAL_LONG);
		registry.accept(         UUID.class, CodecHolders.UUID);
		registry.accept(    class_1799.class, CodecHolders.ITEM_STACK);
		registry.accept(     class_2338.class, CodecHolders.BLOCK_POS);
		registry.accept(    class_4208.class, CodecHolders.GLOBAL_POS);
		registry.accept(  GameProfile.class, CodecHolders.GAME_PROFILE);
		registry.accept(         class_2561.class, CodecHolders.TEXT);
		registry.accept(   class_2960.class, CodecHolders.IDENTIFIER);
		registry.accept(  class_2487.class, CodecHolders.NBT_COMPOUND);
		registry.accept(   class_2520.class, CodecHolders.NBT_ELEMENT);
		registry.accept(  class_5321.class, CodecHolders.REGISTRY_KEY);
		registry.accept(     Vector3f.class, CodecHolders.VECTOR_3F);
		registry.accept(  Quaternionf.class, CodecHolders.QUATERNION_F);
		registry.accept(  class_6017.class, CodecHolders.INT_PROVIDER);
	}

	private static void registerCodecResolvers(Consumer<CodecResolver> registry) {
		// Basic codec resolvers
		registry.accept(new ArrayCodecResolver());
		registry.accept(new PrimitiveCodecResolver());
		registry.accept(new StandardCodecResolver());
		registry.accept(new EnumCodecResolver());
		registry.accept(new RecordCodecResolver());

		// Commonly used resolvers
		registry.accept(new OptionalCodecResolver());
		registry.accept(new EitherCodecResolver());
		registry.accept(new PairCodecResolver());

		// Unique resolvers
		registry.accept(new TagKeyCodecResolver());
	}

	private SerializationEventListener() {

	}
}
