package dev.scsupercraft.mc.libraries.corelib.api.serialization;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.ApiStatus;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalLong;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6862;
import net.minecraft.class_9139;

/**
 * A collection of pre-made {@link class_9139}s.
 */
@ApiStatus.AvailableSince("1.0.0")
public class PacketCodecs implements net.minecraft.class_9135 {
	private PacketCodecs() {}

	/**
	 * A packet codec for {@code char} values.
	 * Encodes characters as single-character strings.
	 */
	@ApiStatus.AvailableSince("1.0.0")
	public static final class_9139<ByteBuf, Character> CHARACTER = field_48554.method_56432(s -> s.charAt(0), c -> String.valueOf((char) c));

	/** A packet codec for {@link UUID} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final class_9139<ByteBuf, UUID> UUID = class_4844.field_48453;

	/** A packet codec for {@link class_6017} values. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final class_9139<ByteBuf, class_6017> INT_PROVIDER = net.minecraft.class_9135.method_56368(class_6017.field_29946);

	/** A packet codec for {@link BigInteger} values, encoded as strings. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final class_9139<ByteBuf, BigInteger> BIG_INTEGER = net.minecraft.class_9135.field_48554.method_56432(BigInteger::new, BigInteger::toString);

	/** A packet codec for {@link BigDecimal} values, encoded as strings. */
	@ApiStatus.AvailableSince("1.0.0")
	public static final class_9139<ByteBuf, BigDecimal> BIG_DECIMAL = net.minecraft.class_9135.field_48554.method_56432(BigDecimal::new, BigDecimal::toString);

	/**
	 * A packet codec for {@link OptionalLong} values.
	 * Encodes presence as a boolean followed by a long if present.
	 */
	@ApiStatus.AvailableSince("1.0.0")
	public static final class_9139<ByteBuf, OptionalLong> OPTIONAL_LONG =
			class_9139.method_56438(
					(value, buf) -> {
						buf.writeBoolean(value.isPresent());
						if (value.isPresent()) buf.writeLong(value.getAsLong());
					},
					buf -> {
						boolean present = buf.readBoolean();
						return present ? OptionalLong.of(buf.readLong()) : OptionalLong.empty();
					}
			);

	/**
	 * A packet codec for {@link class_5321} values.
	 * Encodes registry keys as {@link class_2960}s.
	 */
	@ApiStatus.AvailableSince("1.0.0")
	@SuppressWarnings("rawtypes")
	public static final class_9139<ByteBuf, class_5321> REGISTRY_KEY = class_2960.field_48267.method_56432(class_5321::method_29180, class_5321::method_29177);

	/**
	 * A packet codec for {@link class_6862} values.
	 * Encodes both registry reference and tag ID.
	 */
	@ApiStatus.AvailableSince("1.0.0")
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static final class_9139<ByteBuf, class_6862> TAG_KEY = class_9139.method_56435(
			REGISTRY_KEY,
			class_6862::comp_326,
			class_2960.field_48267,
			class_6862::comp_327,
			class_6862::method_40092
	);
}
